;Move XL OS ROM into RAM;;RAMROM--Installs the XL ROM-based;  OS in RAM at the same address;  space. This is useful for;  making small patches to the;  OS or for experimenting with;  new design concepts, such as;  multitasking, window;  management, etc.;;    By Joe Miller.;;This version is configured;as an AUTORUN.SYS file.;SOURCE  EQU     $CB             ;zero page usageDEST    EQU     SOURCE+2START   EQU     $0600           ;START addressOSROM   EQU     $C000           ;address of OS ROM startOSRAM   EQU     $4000           ;address of ROM                                destinationNMIEN   EQU     $D40E           ;NMI enable registerPORTB   EQU     $D301           ;memory mgt control                                latch        ORG     START        LDA     #low OSROM        STA     SOURCE        STA     DEST            ;initialize copy addrs        LDA     #high OSROM        STA     SOURCE+1        LDA     #high OSRAM        STA     DEST+l        LDY     #0                                ;RepeatPass1   LDA     (SOURCE),Y      ;copy ROM to RAM        STA     (DEST),Y        INY        BNE     Pass1         INC     DEST+1        INC     SOURCE+1        BEQ     Swap            ;If done        LDA     SOURCE+l        CMP     #$D0        BNE     Pass1           ;skip 2K block at $D000        LDA     #$D8        STA     SOURCE+1        BNE     Pass1           ;Until SOURCE = $0000Swap    PHP                     ;save processor status        SEI                     ;disable IRQs        LDA     NMIEN        PHA                     ;save NMIEN        LDA     #0        STA     NMIEN           ;disable NMIs        LDA     PORTB        AND     #$FE            ;turn off ROMs        STA     PORTB           ;(leaving BASIC                                unchanged!)        LDA     #high OSROM        STA     DEST+1          ;set up block copy        LDA     #high OSRAM        STA     SOURCE+1                                ;RepeatPass2   LDA     (SOURCE),Y      ;move RAM OS to proper                                address        STA     (DEST),Y        INY        BNE     Pass2        INC     SOURCE+1        ;move to next page        INC     DEST+1        BEQ     Enable          ;If complete        LDA     DEST+1         CMP     #$D0        BNE     Pass2           ;skip block at $D000        LDA     #$D8        STA     DEST+1        BNE     Pass2           ;Until DEST = $000Enable  PLA        STA     NMIEN           ;reestablish NMI mask        PLP                     ;reenable IRQs        RTS        END     START
